Class extends DataClass

local Function newEntity($seed : Object; $dataType : Text) : cs:C1710.MixEntity  // create an entity, seeding it with data from $seed
	ASSERT:C1129(Count parameters:C259=2; "Mix.newEntity() requires two parameters")
	$0:=This:C1470.new().initConfig($seed; $dataType)  // let the Entity configure anything it needs to for a new record
	
Function cityUUID($name : Text) : Variant  // UUID or Null
	$0:=This:C1470.lookupMatch($name; "City")
	
Function roleUUID($name : Text) : Variant  // UUID or Null
	$0:=This:C1470.lookupMatch($name; "Role")
	
Function deptUUID($name : Text) : Variant  // UUID or Null
	$0:=This:C1470.lookupMatch($name; "Dept")
	
Function lookupMatch($name : Text; $dataType : Text) : Variant
	var $es : cs:C1710.MixSelection
	$0:=Null:C1517
	$es:=This:C1470.query("DataType = :1 AND Name = :2"; $dataType; $name)
	If ($es.length>0)
		$0:=$es[0].UUID
	End if 
	
Function allCities() : cs:C1710.MixSelection
	$0:=This:C1470.query("DataType = :1"; "City").orderBy("Name Asc")
	
Function allRoles() : cs:C1710.MixSelection
	$0:=This:C1470.query("DataType = :1"; "Role").orderBy("Name Asc")
	
Function allDepts() : cs:C1710.MixSelection
	$0:=This:C1470.query("DataType = :1"; "Dept").orderBy("Name Asc")
	