Class extends DataStoreImplementation

local Function newEntity($dClass : Text; $seed : Object; $class : Text) : Object  // create an entity in $dClass, seeding it with data from $seed.  $class is optional information
	If ($dClass="Lib")  // Lib cannot be done through this mechanism
		ASSERT:C1129(True:C214=True:C214; "ds.newEntity(Lib) is invalid. Use ds.Lib.newEntity()")
	Else 
		If (Count parameters:C259<3)  // no 'class' given...
			$0:=ds:C1482[$dClass].newEntity($seed)  // pass it along to the dataClass Class
		Else 
			$0:=ds:C1482[$dClass].newEntity($seed; $class)  // pass it along to the dataClass Class. This dClass requires a 'class' designation
		End if 
	End if 
	
/* ———— ApplyFormula( ); doOnCollection( ); doOnSelection( ) ———— */
Function _formula($formula : Variant) : Object  // if given a FORMULA OBJECT, just return it. If given a TEXT, convert it to a formula and return it
	If (Value type:C1509($formula)=Is text:K8:3)
		$0:=Formula from string:C1601($formula)
	Else 
		$0:=$formula
	End if 
	
	// .applyFormula( ); apply a formula to a selection of entities OR to a collection of objects. 
	// for EntitySelection, returns with any errors from the save
	// result: { .result:true } if all successful;  { .result: false;  .errors: collection }
Function applyFormula($es : Variant; $formula : Variant; $mode : Integer) : Object
	// note: if $mode is not given, 4D defaults it to 0
	$formula:=This:C1470._formula($formula)  // if it is a textual formula, it will be turned into a true formula object
	If (Value type:C1509($es)=Is collection:K8:32)
		ds:C1482.doOnCollection($es; $formula)
	Else 
		var $en : cs:C1710.Entity
		var $obj_Result : Object  // result of the .save( )
		var $errors : Collection  // any .save( ) that failed are returned in this collection
		$errors:=New collection:C1472
		For each ($en; $es)
			$formula.apply($en)
			If ($mode#0)
				$obj_Result:=$en.save($mode)
			Else 
				$obj_Result:=$en.save()
			End if 
			If (Not:C34($obj_Result.success))  // if the save failed, tell the caller
				$obj_Result.en:=$en  // append the entity to the error object
				$errors.push($obj_Result)
			End if 
		End for each 
		If ($errors.length=0)
			$0:=New object:C1471("result"; True:C214)
		Else   // there were entities that failed the formula application
			$0:=New object:C1471("result"; False:C215; "errors"; $errors)  // return the collection of errors, with their messages
		End if 
	End if 
	
Function doOnCollection($col : Collection; $formula : Variant)
	$formula:=This:C1470._formula($formula)  // if it is a textual formula, it will be turned into a true formula object
	var $o : Object
	For each ($o; $col)
		$formula.apply($o)
	End for each 
	
Function doOnSelection($es : Variant; $formula : Variant; $doSave : Boolean) : Object  // note: $formula can access the current entity using This.
	$0:=This:C1470.applyFormula($es; $formula; $doSave)
/* ———— END: ApplyFormula( ); doOnCollection( ); doOnSelection( ) ———— */
	
	